<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TwoDigit extends Model 
{

    protected $table = 'two_digits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('digits', 'amount', 'user_id');

    public function twoDigitsUsers()
    {
        return $this->hasOne('User', 'user_id');
    }

}